import React, { useRef, useEffect, useState } from 'react';

export function Logs({ logs }) {
    const logsEndRef = useRef(null);
    const [autoScroll, setAutoScroll] = useState(true);

    useEffect(() => {
        if (autoScroll && logsEndRef.current) {
            logsEndRef.current.scrollIntoView({ behavior: "smooth" });
        }
    }, [logs, autoScroll]);

    return (
        <div className="logs-container glass-panel flex-1 flex flex-col overflow-hidden min-h-0">
            <div className="logs-header flex justify-between items-center py-2 px-3 border-b border-[var(--glass-border)] bg-[rgba(30,41,59,0.4)]">
                <h3 className="logs-title font-semibold text-xs uppercase tracking-wider text-[var(--text-muted)]">Processing Log</h3>
                <label className="flex items-center gap-2 text-[10px] cursor-pointer select-none text-[var(--text-muted)] hover:text-[var(--text-primary)] transition-colors">
                    <input
                        type="checkbox"
                        checked={autoScroll}
                        onChange={(e) => setAutoScroll(e.target.checked)}
                        className="accent-[var(--accent-primary)] w-3 h-3"
                    />
                    Auto-scroll
                </label>
            </div>

            <div className="logs-list flex-1 overflow-y-auto p-3 space-y-2 bg-[rgba(15,23,42,0.3)]">
                {logs.length === 0 && (
                    <div className="flex flex-col items-center justify-center h-full text-[var(--text-muted)] opacity-50">
                        <span className="text-xs italic">Waiting for tasks...</span>
                    </div>
                )}
                {logs.map((log, i) => (
                    <div key={i} className={`log-entry flex gap-2 text-[11px] font-mono leading-tight animate-in fade-in slide-in-from-bottom-1 duration-200`}>
                        <span className="log-time text-[var(--text-tertiary)] min-w-[50px] opacity-70">
                            {log.timestamp}
                        </span>
                        <span className={`log-message break-words flex-1 ${log.level === 'error' ? 'text-red-400 font-medium' :
                            log.level === 'success' ? 'text-emerald-400 font-medium' :
                                log.level === 'warning' ? 'text-amber-400' :
                                    'text-[var(--text-primary)] opacity-90'
                            }`}>
                            {log.message}
                        </span>
                    </div>
                ))}
                <div ref={logsEndRef} />
            </div>
        </div>
    );
}
